/* Initialize modal box */
var modal = (function(){
	var 
	method = {},
	$overlay,
	$modal,
	$content,
	$close;

	// Center the modal in the viewport
	method.center = function () {
		var top, left;

		top = Math.max($(window).height() - $modal.outerHeight(), 0) / 2;
		left = Math.max($(window).width() - $modal.outerWidth(), 0) / 2;

		$modal.css({
			top:top + $(window).scrollTop(), 
			left:left + $(window).scrollLeft()
		});
	};

	// Open the modal
	method.open = function (settings) {
		if(ShowModalPopup=="yes")
		{
		$content.empty().append(settings.content);

		$modal.css({
			width: settings.width || 'auto', 
			height: settings.height || 'auto'
			//width: '640px', 
			//height: '480px'
		});

		method.center();
		$(window).bind('resize.modal', method.center);
		$modal.show();
		$overlay.show();
		
		method.close = function () {
                $modal.hide();
                $overlay.hide();
                $content.empty();
                $(window).unbind('resize.modal');
		
		 };

	}
	};

	// Close the modal
	method.close = function () {
		$modal.hide();
		$overlay.hide();
		$content.empty();
		$(window).unbind('resize.modal');
	};

	// Generate the HTML and add it to the document
	$overlay = $('<div id="box-overlay"></div>');
	$modal = $('<div id="box-modal"></div>');
	$content = $('<div id="box-content"></div>');
	$close = $('<a id="box-close" href="#"><span>Close</span></a>');

	$modal.hide();
	$overlay.hide();
	$modal.append($content, $close);

	$(document).ready(function(){
		$('body').append($overlay, $modal);						
	});

	$close.click(function(e){
		e.preventDefault();
		method.close();
	});

	return method;
}());

/* Initialize cookie vars.
   Expiration is not used because customer requested cookie to expire at end of session. */
var expDays = 1; // number of days the cookie should last
var page = "/site/misc/survey.xhtml";
//var windowprops = "top=200,left=200,width=640,height=480,location=no,toolbar=no,menubar=no,scrollbars=yes,resizable=yes";
var exp = new Date();
exp.setTime(exp.getTime() + (expDays*24*60*60*1000));

/* Read cookie */
function GetCookie (name) {
  var arg = name + "=";
  var alen = arg.length;
  var clen = document.cookie.length;
  var i = 0;
  while (i < clen) {
    var j = i + alen;
    if (document.cookie.substring(i, j) == arg)
    return getCookieVal (j);
    i = document.cookie.indexOf(" ", i) + 1;
    if (i == 0) break;
  }
  return null;
}

/* Set cookie */
function SetCookie (name, value) {
  var argv = SetCookie.arguments;
  var argc = SetCookie.arguments.length;
  var expires = (argc > 2) ? argv[2] : null;
  var path = (argc > 3) ? argv[3] : null;
  var domain = (argc > 4) ? argv[4] : null;
  var secure = (argc > 5) ? argv[5] : false;
  document.cookie = name + "=" + escape (value) +
    ((expires == null) ? "" : ("; expires=" + expires.toGMTString())) +
    ((path == null) ? "" : ("; path=" + path)) +
    ((domain == null) ? "" : ("; domain=" + domain)) +
    ((secure == true) ? "; secure" : "");
}

function getCookieVal(offset) {
  var endstr = document.cookie.indexOf (";", offset);
  if (endstr == -1)
  endstr = document.cookie.length;
  return unescape(document.cookie.substring(offset, endstr));
}

/* Trigger modal box */
function checkCount() {
  var count = GetCookie('survey');
  if (count == null) {
    var mywindow = $.get(page, function(data){
		modal.open({content: data});
	});
    if (mywindow != null) {
      count=1;
      SetCookie('survey', count);
    }
  } else {
    count++;
    SetCookie('survey', count);
  }
}

window.onload=checkCount;
